/*
 * Decompiled with CFR 0.152.
 */
package com.dto;

import com.dto.CustomerAddressDto;
import com.dto.CustomerDto;
import com.dto.CustomerVasetehDto;
import com.google.gson.annotations.SerializedName;
import com.utility.ConvertStr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.NonNull;

public class CustomerDto {
    private String id;
    private String code;
    private String name;
    private String nationalid;
    private String economicid;
    private String bedsarfasl;
    private String bessarfasl;
    private Boolean ispurchaser;
    private Boolean isseller;
    private Boolean isamer;
    private int sellerwithtax;
    private Boolean isblacklist;
    private Double mandeh;
    private Double credit;
    private int custtype;
    private Boolean isvaseteh;
    private Double vasetehporsant;
    private Double commission;
    private String tel;
    private String mobile;
    private String fax;
    private String city;
    private String citycode;
    private String ostan;
    private String ostancode;
    private String mantagheh;
    private String zipcode;
    private String address;
    private String addresstitle;
    @SerializedName(value="moreaddress", alternate={"moreAddress", "MoreAddress"})
    private List<CustomerAddressDto> moreAddress;
    private String job;
    private String birthdate;
    private String email;
    private String erpcode;
    private String cCode;
    private String inputid;
    private String c_code;
    private Integer type;
    private Integer isupdate;
    private boolean isactive;
    private String lastbuyprice;
    private String lastsellprice;
    @SerializedName(value="nationalcodef")
    private String nationalCodeF;
    @SerializedName(value="personalcodef")
    private String personalCodeF;
    @SerializedName(value="companycodef")
    private String companyCodeF;
    private Integer vasetehcount;
    private Double latitude;
    private Double longitude;
    private String midmancode;
    private long category;
    private String nickname;
    private String citycodelevy;
    private int selecttype;
    @SerializedName(value="vaseteh", alternate={"customerVasetehDto", "CustomerVasetehDto"})
    private List<CustomerVasetehDto> customerVasetehDto;

    public String getColCodeBed() {
        if (!ConvertStr.isNullOrEmpty((String)this.bedsarfasl)) {
            return this.bedsarfasl.substring(0, 3);
        }
        return "";
    }

    public String getMoienCodeBed() {
        if (!ConvertStr.isNullOrEmpty((String)this.bedsarfasl) && this.bedsarfasl.length() > 5) {
            return this.bedsarfasl.substring(3, 7);
        }
        return "";
    }

    public String getTafziliCodeBed() {
        if (!ConvertStr.isNullOrEmpty((String)this.bedsarfasl) && this.bedsarfasl.length() > 8) {
            return this.bedsarfasl.substring(7, 11);
        }
        return "";
    }

    public String getColCodeBes() {
        if (!ConvertStr.isNullOrEmpty((String)this.bessarfasl)) {
            return this.bessarfasl.substring(0, 3);
        }
        return "";
    }

    public String getMoienCodeBes() {
        if (!ConvertStr.isNullOrEmpty((String)this.bessarfasl) && this.bessarfasl.length() > 5) {
            return this.bessarfasl.substring(3, 7);
        }
        return "";
    }

    public String getTafziliCodeBes() {
        if (!ConvertStr.isNullOrEmpty((String)this.bessarfasl) && this.bessarfasl.length() > 8) {
            return this.bessarfasl.substring(7, 11);
        }
        return "";
    }

    public String getUpdateAddressesSql() {
        int i;
        if (ConvertStr.isNullOrEmpty((Collection)this.moreAddress)) {
            return "";
        }
        StringBuilder sb = new StringBuilder("UPDATE CUST_TELL SET ");
        String addressSql = "C_ADDRESS";
        String addressTitleSql = "C_AddressTitle";
        for (i = 0; i < CustomerAddressDto.MAX_ID - 1; ++i) {
            sb.append(addressSql).append(i + 1).append(" = ");
            if (i >= this.moreAddress.size()) {
                sb.append("null, ");
                continue;
            }
            sb.append(ConvertStr.toQuotedSqlStr((String)((CustomerAddressDto)this.moreAddress.get(i)).getAddress())).append(", ");
        }
        if (!ConvertStr.isNullOrEmpty((String)this.addresstitle)) {
            sb.append(addressTitleSql).append(" = ").append(this.addresstitle).append(", ");
        }
        for (i = 0; i < CustomerAddressDto.MAX_ID - 1; ++i) {
            sb.append(addressTitleSql).append(i + 1).append(" = ");
            if (i >= this.moreAddress.size()) {
                sb.append("null, ");
                continue;
            }
            sb.append(ConvertStr.toQuotedSqlStr((String)((CustomerAddressDto)this.moreAddress.get(i)).getTitle())).append(", ");
        }
        sb = ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)",").append(" WHERE CCode = '").append(this.id).append("' \n");
        return sb.toString();
    }

    public void rearrangeAddressIds(JdbcTemplate jdbc) {
        List allGivenAddress = this.getAllGivenAddresses();
        List allInsertedAddress = this.getAllInsertedAddresses(jdbc);
        ArrayList toRemoveList = new ArrayList();
        for (CustomerAddressDto givenAddress : allGivenAddress) {
            int insertedAddressIndex = givenAddress.getId() - 1;
            if (givenAddress.shouldDelete()) {
                this.lowerBiggerIds(allInsertedAddress, insertedAddressIndex);
                toRemoveList.add(allInsertedAddress.get(insertedAddressIndex));
                continue;
            }
            if (allInsertedAddress.size() <= insertedAddressIndex) continue;
            CustomerAddressDto addressDto = (CustomerAddressDto)allInsertedAddress.get(insertedAddressIndex);
            if (givenAddress.getAddress() != null) {
                addressDto.setAddress(givenAddress.getAddress());
            }
            if (givenAddress.getTitle() == null) continue;
            addressDto.setTitle(givenAddress.getTitle());
        }
        for (CustomerAddressDto toRemove : toRemoveList) {
            allInsertedAddress.remove(toRemove);
        }
        this.moreAddress.clear();
        for (CustomerAddressDto insertedAddress : allInsertedAddress) {
            if (insertedAddress.getId() == 1) {
                this.address = insertedAddress.getAddress();
                this.addresstitle = insertedAddress.getTitle();
                continue;
            }
            this.moreAddress.add(insertedAddress);
        }
    }

    private void lowerBiggerIds(List<CustomerAddressDto> allInsertedAddress, int removingIndex) {
        for (int i = removingIndex + 1; i < CustomerAddressDto.MAX_ID; ++i) {
            CustomerAddressDto dto = allInsertedAddress.get(i);
            dto.setId(i);
        }
    }

    public String getInsertAddressesSql() {
        CustomerAddressDto addressDto;
        int i;
        if (ConvertStr.isNullOrEmpty((Collection)this.moreAddress)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" INSERT INTO [CUST_TELL] (CCode, C_Address1, C_Address2, \n C_Address3, C_Address4, C_Address5, C_AddressTitle, C_AddressTitle1, C_AddressTitle2, \n C_AddressTitle3, C_AddressTitle4, C_AddressTitle5) \n VALUES ('" + this.id + "', ");
        for (i = 0; i < 5; ++i) {
            if (i >= this.moreAddress.size()) {
                sb.append("NULL,");
                continue;
            }
            addressDto = (CustomerAddressDto)this.moreAddress.get(i);
            sb.append("'").append(addressDto.getAddress()).append("',");
            addressDto.setId(i + 2);
        }
        sb.append(ConvertStr.toQuotedSqlStr((String)this.addresstitle)).append(", ");
        for (i = 0; i < 5; ++i) {
            if (i >= this.moreAddress.size()) {
                sb.append("NULL,");
                continue;
            }
            addressDto = (CustomerAddressDto)this.moreAddress.get(i);
            sb.append("'").append(addressDto.getTitle()).append("',");
        }
        sb.append(")");
        ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)",");
        return sb.toString();
    }

    @NonNull
    public List<CustomerAddressDto> getAllGivenAddresses() {
        if (ConvertStr.isNullOrEmpty((Collection)this.moreAddress)) {
            this.moreAddress = new ArrayList();
        }
        if (ConvertStr.isNullOrEmpty((String)this.address)) {
            return this.moreAddress;
        }
        ArrayList<CustomerAddressDto> allAddress = new ArrayList<CustomerAddressDto>();
        allAddress.add(new CustomerAddressDto(1, this.address, this.addresstitle));
        for (CustomerAddressDto addressDto : this.moreAddress) {
            if (!addressDto.includeInGivenAddresses()) continue;
            allAddress.add(addressDto);
        }
        return allAddress;
    }

    @NonNull
    public List<CustomerAddressDto> getAllInsertedAddresses(JdbcTemplate jdbc) {
        ArrayList<CustomerAddressDto> all = new ArrayList<CustomerAddressDto>();
        SqlRowSet rs = jdbc.queryForRowSet("SELECT C_ADDRESS '1', C_ADDRESS1 '2', C_ADDRESS2 '3', \n C_ADDRESS3 '4', C_ADDRESS4 '5', C_ADDRESS5 '6', C_AddressTitle '11', C_AddressTitle1 '22', \n C_AddressTitle2 '33', C_AddressTitle3 '44', C_AddressTitle4 '55', C_AddressTitle5 '66' FROM CUST_TELL \n INNER JOIN CUSTOMER ON CCode = C_CODE \n WHERE CCode = ?", new Object[]{this.id});
        if (!rs.next()) {
            return all;
        }
        for (int i = 1; i <= 6; ++i) {
            String iStr = String.valueOf(i);
            all.add(new CustomerAddressDto(i, rs.getString(iStr), rs.getString(iStr + iStr)));
        }
        return all;
    }

    public boolean invalidIds() {
        for (CustomerAddressDto addressDto : this.moreAddress) {
            if (!addressDto.invalidId()) continue;
            return true;
        }
        return false;
    }

    public boolean invalidAddressTitlesInsert() {
        for (CustomerAddressDto givenAddress : this.getAllGivenAddresses()) {
            if (!ConvertStr.isNullOrEmpty((String)givenAddress.getAddress()) || ConvertStr.isNullOrEmpty((String)givenAddress.getTitle())) continue;
            return true;
        }
        return false;
    }

    public boolean invalidAddressTitlesUpdate() {
        for (CustomerAddressDto givenAddress : this.getAllGivenAddresses()) {
            if (!givenAddress.shouldDelete() || ConvertStr.isNullOrEmpty((String)givenAddress.getTitle())) continue;
            return true;
        }
        return false;
    }

    CustomerDto(String id, String code, String name, String nationalid, String economicid, String bedsarfasl, String bessarfasl, Boolean ispurchaser, Boolean isseller, Boolean isamer, int sellerwithtax, Boolean isblacklist, Double mandeh, Double credit, int custtype, Boolean isvaseteh, Double vasetehporsant, Double commission, String tel, String mobile, String fax, String city, String citycode, String ostan, String ostancode, String mantagheh, String zipcode, String address, String addresstitle, List<CustomerAddressDto> moreAddress, String job, String birthdate, String email, String erpcode, String cCode, String inputid, String c_code, Integer type, Integer isupdate, boolean isactive, String lastbuyprice, String lastsellprice, String nationalCodeF, String personalCodeF, String companyCodeF, Integer vasetehcount, Double latitude, Double longitude, String midmancode, long category, String nickname, String citycodelevy, int selecttype, List<CustomerVasetehDto> customerVasetehDto) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.nationalid = nationalid;
        this.economicid = economicid;
        this.bedsarfasl = bedsarfasl;
        this.bessarfasl = bessarfasl;
        this.ispurchaser = ispurchaser;
        this.isseller = isseller;
        this.isamer = isamer;
        this.sellerwithtax = sellerwithtax;
        this.isblacklist = isblacklist;
        this.mandeh = mandeh;
        this.credit = credit;
        this.custtype = custtype;
        this.isvaseteh = isvaseteh;
        this.vasetehporsant = vasetehporsant;
        this.commission = commission;
        this.tel = tel;
        this.mobile = mobile;
        this.fax = fax;
        this.city = city;
        this.citycode = citycode;
        this.ostan = ostan;
        this.ostancode = ostancode;
        this.mantagheh = mantagheh;
        this.zipcode = zipcode;
        this.address = address;
        this.addresstitle = addresstitle;
        this.moreAddress = moreAddress;
        this.job = job;
        this.birthdate = birthdate;
        this.email = email;
        this.erpcode = erpcode;
        this.cCode = cCode;
        this.inputid = inputid;
        this.c_code = c_code;
        this.type = type;
        this.isupdate = isupdate;
        this.isactive = isactive;
        this.lastbuyprice = lastbuyprice;
        this.lastsellprice = lastsellprice;
        this.nationalCodeF = nationalCodeF;
        this.personalCodeF = personalCodeF;
        this.companyCodeF = companyCodeF;
        this.vasetehcount = vasetehcount;
        this.latitude = latitude;
        this.longitude = longitude;
        this.midmancode = midmancode;
        this.category = category;
        this.nickname = nickname;
        this.citycodelevy = citycodelevy;
        this.selecttype = selecttype;
        this.customerVasetehDto = customerVasetehDto;
    }

    public static CustomerDtoBuilder builder() {
        return new CustomerDtoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getNationalid() {
        return this.nationalid;
    }

    public String getEconomicid() {
        return this.economicid;
    }

    public String getBedsarfasl() {
        return this.bedsarfasl;
    }

    public String getBessarfasl() {
        return this.bessarfasl;
    }

    public Boolean getIspurchaser() {
        return this.ispurchaser;
    }

    public Boolean getIsseller() {
        return this.isseller;
    }

    public Boolean getIsamer() {
        return this.isamer;
    }

    public int getSellerwithtax() {
        return this.sellerwithtax;
    }

    public Boolean getIsblacklist() {
        return this.isblacklist;
    }

    public Double getMandeh() {
        return this.mandeh;
    }

    public Double getCredit() {
        return this.credit;
    }

    public int getCusttype() {
        return this.custtype;
    }

    public Boolean getIsvaseteh() {
        return this.isvaseteh;
    }

    public Double getVasetehporsant() {
        return this.vasetehporsant;
    }

    public Double getCommission() {
        return this.commission;
    }

    public String getTel() {
        return this.tel;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getFax() {
        return this.fax;
    }

    public String getCity() {
        return this.city;
    }

    public String getCitycode() {
        return this.citycode;
    }

    public String getOstan() {
        return this.ostan;
    }

    public String getOstancode() {
        return this.ostancode;
    }

    public String getMantagheh() {
        return this.mantagheh;
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddresstitle() {
        return this.addresstitle;
    }

    public List<CustomerAddressDto> getMoreAddress() {
        return this.moreAddress;
    }

    public String getJob() {
        return this.job;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public String getEmail() {
        return this.email;
    }

    public String getErpcode() {
        return this.erpcode;
    }

    public String getCCode() {
        return this.cCode;
    }

    public String getInputid() {
        return this.inputid;
    }

    public String getC_code() {
        return this.c_code;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getIsupdate() {
        return this.isupdate;
    }

    public boolean isIsactive() {
        return this.isactive;
    }

    public String getLastbuyprice() {
        return this.lastbuyprice;
    }

    public String getLastsellprice() {
        return this.lastsellprice;
    }

    public String getNationalCodeF() {
        return this.nationalCodeF;
    }

    public String getPersonalCodeF() {
        return this.personalCodeF;
    }

    public String getCompanyCodeF() {
        return this.companyCodeF;
    }

    public Integer getVasetehcount() {
        return this.vasetehcount;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getMidmancode() {
        return this.midmancode;
    }

    public long getCategory() {
        return this.category;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getCitycodelevy() {
        return this.citycodelevy;
    }

    public int getSelecttype() {
        return this.selecttype;
    }

    public List<CustomerVasetehDto> getCustomerVasetehDto() {
        return this.customerVasetehDto;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNationalid(String nationalid) {
        this.nationalid = nationalid;
    }

    public void setEconomicid(String economicid) {
        this.economicid = economicid;
    }

    public void setBedsarfasl(String bedsarfasl) {
        this.bedsarfasl = bedsarfasl;
    }

    public void setBessarfasl(String bessarfasl) {
        this.bessarfasl = bessarfasl;
    }

    public void setIspurchaser(Boolean ispurchaser) {
        this.ispurchaser = ispurchaser;
    }

    public void setIsseller(Boolean isseller) {
        this.isseller = isseller;
    }

    public void setIsamer(Boolean isamer) {
        this.isamer = isamer;
    }

    public void setSellerwithtax(int sellerwithtax) {
        this.sellerwithtax = sellerwithtax;
    }

    public void setIsblacklist(Boolean isblacklist) {
        this.isblacklist = isblacklist;
    }

    public void setMandeh(Double mandeh) {
        this.mandeh = mandeh;
    }

    public void setCredit(Double credit) {
        this.credit = credit;
    }

    public void setCusttype(int custtype) {
        this.custtype = custtype;
    }

    public void setIsvaseteh(Boolean isvaseteh) {
        this.isvaseteh = isvaseteh;
    }

    public void setVasetehporsant(Double vasetehporsant) {
        this.vasetehporsant = vasetehporsant;
    }

    public void setCommission(Double commission) {
        this.commission = commission;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setCitycode(String citycode) {
        this.citycode = citycode;
    }

    public void setOstan(String ostan) {
        this.ostan = ostan;
    }

    public void setOstancode(String ostancode) {
        this.ostancode = ostancode;
    }

    public void setMantagheh(String mantagheh) {
        this.mantagheh = mantagheh;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setAddresstitle(String addresstitle) {
        this.addresstitle = addresstitle;
    }

    public void setMoreAddress(List<CustomerAddressDto> moreAddress) {
        this.moreAddress = moreAddress;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setErpcode(String erpcode) {
        this.erpcode = erpcode;
    }

    public void setCCode(String cCode) {
        this.cCode = cCode;
    }

    public void setInputid(String inputid) {
        this.inputid = inputid;
    }

    public void setC_code(String c_code) {
        this.c_code = c_code;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setIsupdate(Integer isupdate) {
        this.isupdate = isupdate;
    }

    public void setIsactive(boolean isactive) {
        this.isactive = isactive;
    }

    public void setLastbuyprice(String lastbuyprice) {
        this.lastbuyprice = lastbuyprice;
    }

    public void setLastsellprice(String lastsellprice) {
        this.lastsellprice = lastsellprice;
    }

    public void setNationalCodeF(String nationalCodeF) {
        this.nationalCodeF = nationalCodeF;
    }

    public void setPersonalCodeF(String personalCodeF) {
        this.personalCodeF = personalCodeF;
    }

    public void setCompanyCodeF(String companyCodeF) {
        this.companyCodeF = companyCodeF;
    }

    public void setVasetehcount(Integer vasetehcount) {
        this.vasetehcount = vasetehcount;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setMidmancode(String midmancode) {
        this.midmancode = midmancode;
    }

    public void setCategory(long category) {
        this.category = category;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setCitycodelevy(String citycodelevy) {
        this.citycodelevy = citycodelevy;
    }

    public void setSelecttype(int selecttype) {
        this.selecttype = selecttype;
    }

    public void setCustomerVasetehDto(List<CustomerVasetehDto> customerVasetehDto) {
        this.customerVasetehDto = customerVasetehDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerDto)) {
            return false;
        }
        CustomerDto other = (CustomerDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSellerwithtax() != other.getSellerwithtax()) {
            return false;
        }
        if (this.getCusttype() != other.getCusttype()) {
            return false;
        }
        if (this.isIsactive() != other.isIsactive()) {
            return false;
        }
        if (this.getCategory() != other.getCategory()) {
            return false;
        }
        if (this.getSelecttype() != other.getSelecttype()) {
            return false;
        }
        Boolean this$ispurchaser = this.getIspurchaser();
        Boolean other$ispurchaser = other.getIspurchaser();
        if (this$ispurchaser == null ? other$ispurchaser != null : !((Object)this$ispurchaser).equals(other$ispurchaser)) {
            return false;
        }
        Boolean this$isseller = this.getIsseller();
        Boolean other$isseller = other.getIsseller();
        if (this$isseller == null ? other$isseller != null : !((Object)this$isseller).equals(other$isseller)) {
            return false;
        }
        Boolean this$isamer = this.getIsamer();
        Boolean other$isamer = other.getIsamer();
        if (this$isamer == null ? other$isamer != null : !((Object)this$isamer).equals(other$isamer)) {
            return false;
        }
        Boolean this$isblacklist = this.getIsblacklist();
        Boolean other$isblacklist = other.getIsblacklist();
        if (this$isblacklist == null ? other$isblacklist != null : !((Object)this$isblacklist).equals(other$isblacklist)) {
            return false;
        }
        Double this$mandeh = this.getMandeh();
        Double other$mandeh = other.getMandeh();
        if (this$mandeh == null ? other$mandeh != null : !((Object)this$mandeh).equals(other$mandeh)) {
            return false;
        }
        Double this$credit = this.getCredit();
        Double other$credit = other.getCredit();
        if (this$credit == null ? other$credit != null : !((Object)this$credit).equals(other$credit)) {
            return false;
        }
        Boolean this$isvaseteh = this.getIsvaseteh();
        Boolean other$isvaseteh = other.getIsvaseteh();
        if (this$isvaseteh == null ? other$isvaseteh != null : !((Object)this$isvaseteh).equals(other$isvaseteh)) {
            return false;
        }
        Double this$vasetehporsant = this.getVasetehporsant();
        Double other$vasetehporsant = other.getVasetehporsant();
        if (this$vasetehporsant == null ? other$vasetehporsant != null : !((Object)this$vasetehporsant).equals(other$vasetehporsant)) {
            return false;
        }
        Double this$commission = this.getCommission();
        Double other$commission = other.getCommission();
        if (this$commission == null ? other$commission != null : !((Object)this$commission).equals(other$commission)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$isupdate = this.getIsupdate();
        Integer other$isupdate = other.getIsupdate();
        if (this$isupdate == null ? other$isupdate != null : !((Object)this$isupdate).equals(other$isupdate)) {
            return false;
        }
        Integer this$vasetehcount = this.getVasetehcount();
        Integer other$vasetehcount = other.getVasetehcount();
        if (this$vasetehcount == null ? other$vasetehcount != null : !((Object)this$vasetehcount).equals(other$vasetehcount)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$nationalid = this.getNationalid();
        String other$nationalid = other.getNationalid();
        if (this$nationalid == null ? other$nationalid != null : !this$nationalid.equals(other$nationalid)) {
            return false;
        }
        String this$economicid = this.getEconomicid();
        String other$economicid = other.getEconomicid();
        if (this$economicid == null ? other$economicid != null : !this$economicid.equals(other$economicid)) {
            return false;
        }
        String this$bedsarfasl = this.getBedsarfasl();
        String other$bedsarfasl = other.getBedsarfasl();
        if (this$bedsarfasl == null ? other$bedsarfasl != null : !this$bedsarfasl.equals(other$bedsarfasl)) {
            return false;
        }
        String this$bessarfasl = this.getBessarfasl();
        String other$bessarfasl = other.getBessarfasl();
        if (this$bessarfasl == null ? other$bessarfasl != null : !this$bessarfasl.equals(other$bessarfasl)) {
            return false;
        }
        String this$tel = this.getTel();
        String other$tel = other.getTel();
        if (this$tel == null ? other$tel != null : !this$tel.equals(other$tel)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$fax = this.getFax();
        String other$fax = other.getFax();
        if (this$fax == null ? other$fax != null : !this$fax.equals(other$fax)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$citycode = this.getCitycode();
        String other$citycode = other.getCitycode();
        if (this$citycode == null ? other$citycode != null : !this$citycode.equals(other$citycode)) {
            return false;
        }
        String this$ostan = this.getOstan();
        String other$ostan = other.getOstan();
        if (this$ostan == null ? other$ostan != null : !this$ostan.equals(other$ostan)) {
            return false;
        }
        String this$ostancode = this.getOstancode();
        String other$ostancode = other.getOstancode();
        if (this$ostancode == null ? other$ostancode != null : !this$ostancode.equals(other$ostancode)) {
            return false;
        }
        String this$mantagheh = this.getMantagheh();
        String other$mantagheh = other.getMantagheh();
        if (this$mantagheh == null ? other$mantagheh != null : !this$mantagheh.equals(other$mantagheh)) {
            return false;
        }
        String this$zipcode = this.getZipcode();
        String other$zipcode = other.getZipcode();
        if (this$zipcode == null ? other$zipcode != null : !this$zipcode.equals(other$zipcode)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$addresstitle = this.getAddresstitle();
        String other$addresstitle = other.getAddresstitle();
        if (this$addresstitle == null ? other$addresstitle != null : !this$addresstitle.equals(other$addresstitle)) {
            return false;
        }
        List this$moreAddress = this.getMoreAddress();
        List other$moreAddress = other.getMoreAddress();
        if (this$moreAddress == null ? other$moreAddress != null : !((Object)this$moreAddress).equals(other$moreAddress)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$birthdate = this.getBirthdate();
        String other$birthdate = other.getBirthdate();
        if (this$birthdate == null ? other$birthdate != null : !this$birthdate.equals(other$birthdate)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$erpcode = this.getErpcode();
        String other$erpcode = other.getErpcode();
        if (this$erpcode == null ? other$erpcode != null : !this$erpcode.equals(other$erpcode)) {
            return false;
        }
        String this$cCode = this.getCCode();
        String other$cCode = other.getCCode();
        if (this$cCode == null ? other$cCode != null : !this$cCode.equals(other$cCode)) {
            return false;
        }
        String this$inputid = this.getInputid();
        String other$inputid = other.getInputid();
        if (this$inputid == null ? other$inputid != null : !this$inputid.equals(other$inputid)) {
            return false;
        }
        String this$c_code = this.getC_code();
        String other$c_code = other.getC_code();
        if (this$c_code == null ? other$c_code != null : !this$c_code.equals(other$c_code)) {
            return false;
        }
        String this$lastbuyprice = this.getLastbuyprice();
        String other$lastbuyprice = other.getLastbuyprice();
        if (this$lastbuyprice == null ? other$lastbuyprice != null : !this$lastbuyprice.equals(other$lastbuyprice)) {
            return false;
        }
        String this$lastsellprice = this.getLastsellprice();
        String other$lastsellprice = other.getLastsellprice();
        if (this$lastsellprice == null ? other$lastsellprice != null : !this$lastsellprice.equals(other$lastsellprice)) {
            return false;
        }
        String this$nationalCodeF = this.getNationalCodeF();
        String other$nationalCodeF = other.getNationalCodeF();
        if (this$nationalCodeF == null ? other$nationalCodeF != null : !this$nationalCodeF.equals(other$nationalCodeF)) {
            return false;
        }
        String this$personalCodeF = this.getPersonalCodeF();
        String other$personalCodeF = other.getPersonalCodeF();
        if (this$personalCodeF == null ? other$personalCodeF != null : !this$personalCodeF.equals(other$personalCodeF)) {
            return false;
        }
        String this$companyCodeF = this.getCompanyCodeF();
        String other$companyCodeF = other.getCompanyCodeF();
        if (this$companyCodeF == null ? other$companyCodeF != null : !this$companyCodeF.equals(other$companyCodeF)) {
            return false;
        }
        String this$midmancode = this.getMidmancode();
        String other$midmancode = other.getMidmancode();
        if (this$midmancode == null ? other$midmancode != null : !this$midmancode.equals(other$midmancode)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$citycodelevy = this.getCitycodelevy();
        String other$citycodelevy = other.getCitycodelevy();
        if (this$citycodelevy == null ? other$citycodelevy != null : !this$citycodelevy.equals(other$citycodelevy)) {
            return false;
        }
        List this$customerVasetehDto = this.getCustomerVasetehDto();
        List other$customerVasetehDto = other.getCustomerVasetehDto();
        return !(this$customerVasetehDto == null ? other$customerVasetehDto != null : !((Object)this$customerVasetehDto).equals(other$customerVasetehDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomerDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSellerwithtax();
        result = result * 59 + this.getCusttype();
        result = result * 59 + (this.isIsactive() ? 79 : 97);
        long $category = this.getCategory();
        result = result * 59 + (int)($category >>> 32 ^ $category);
        result = result * 59 + this.getSelecttype();
        Boolean $ispurchaser = this.getIspurchaser();
        result = result * 59 + ($ispurchaser == null ? 43 : ((Object)$ispurchaser).hashCode());
        Boolean $isseller = this.getIsseller();
        result = result * 59 + ($isseller == null ? 43 : ((Object)$isseller).hashCode());
        Boolean $isamer = this.getIsamer();
        result = result * 59 + ($isamer == null ? 43 : ((Object)$isamer).hashCode());
        Boolean $isblacklist = this.getIsblacklist();
        result = result * 59 + ($isblacklist == null ? 43 : ((Object)$isblacklist).hashCode());
        Double $mandeh = this.getMandeh();
        result = result * 59 + ($mandeh == null ? 43 : ((Object)$mandeh).hashCode());
        Double $credit = this.getCredit();
        result = result * 59 + ($credit == null ? 43 : ((Object)$credit).hashCode());
        Boolean $isvaseteh = this.getIsvaseteh();
        result = result * 59 + ($isvaseteh == null ? 43 : ((Object)$isvaseteh).hashCode());
        Double $vasetehporsant = this.getVasetehporsant();
        result = result * 59 + ($vasetehporsant == null ? 43 : ((Object)$vasetehporsant).hashCode());
        Double $commission = this.getCommission();
        result = result * 59 + ($commission == null ? 43 : ((Object)$commission).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $isupdate = this.getIsupdate();
        result = result * 59 + ($isupdate == null ? 43 : ((Object)$isupdate).hashCode());
        Integer $vasetehcount = this.getVasetehcount();
        result = result * 59 + ($vasetehcount == null ? 43 : ((Object)$vasetehcount).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $nationalid = this.getNationalid();
        result = result * 59 + ($nationalid == null ? 43 : $nationalid.hashCode());
        String $economicid = this.getEconomicid();
        result = result * 59 + ($economicid == null ? 43 : $economicid.hashCode());
        String $bedsarfasl = this.getBedsarfasl();
        result = result * 59 + ($bedsarfasl == null ? 43 : $bedsarfasl.hashCode());
        String $bessarfasl = this.getBessarfasl();
        result = result * 59 + ($bessarfasl == null ? 43 : $bessarfasl.hashCode());
        String $tel = this.getTel();
        result = result * 59 + ($tel == null ? 43 : $tel.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $fax = this.getFax();
        result = result * 59 + ($fax == null ? 43 : $fax.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $citycode = this.getCitycode();
        result = result * 59 + ($citycode == null ? 43 : $citycode.hashCode());
        String $ostan = this.getOstan();
        result = result * 59 + ($ostan == null ? 43 : $ostan.hashCode());
        String $ostancode = this.getOstancode();
        result = result * 59 + ($ostancode == null ? 43 : $ostancode.hashCode());
        String $mantagheh = this.getMantagheh();
        result = result * 59 + ($mantagheh == null ? 43 : $mantagheh.hashCode());
        String $zipcode = this.getZipcode();
        result = result * 59 + ($zipcode == null ? 43 : $zipcode.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $addresstitle = this.getAddresstitle();
        result = result * 59 + ($addresstitle == null ? 43 : $addresstitle.hashCode());
        List $moreAddress = this.getMoreAddress();
        result = result * 59 + ($moreAddress == null ? 43 : ((Object)$moreAddress).hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $birthdate = this.getBirthdate();
        result = result * 59 + ($birthdate == null ? 43 : $birthdate.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $erpcode = this.getErpcode();
        result = result * 59 + ($erpcode == null ? 43 : $erpcode.hashCode());
        String $cCode = this.getCCode();
        result = result * 59 + ($cCode == null ? 43 : $cCode.hashCode());
        String $inputid = this.getInputid();
        result = result * 59 + ($inputid == null ? 43 : $inputid.hashCode());
        String $c_code = this.getC_code();
        result = result * 59 + ($c_code == null ? 43 : $c_code.hashCode());
        String $lastbuyprice = this.getLastbuyprice();
        result = result * 59 + ($lastbuyprice == null ? 43 : $lastbuyprice.hashCode());
        String $lastsellprice = this.getLastsellprice();
        result = result * 59 + ($lastsellprice == null ? 43 : $lastsellprice.hashCode());
        String $nationalCodeF = this.getNationalCodeF();
        result = result * 59 + ($nationalCodeF == null ? 43 : $nationalCodeF.hashCode());
        String $personalCodeF = this.getPersonalCodeF();
        result = result * 59 + ($personalCodeF == null ? 43 : $personalCodeF.hashCode());
        String $companyCodeF = this.getCompanyCodeF();
        result = result * 59 + ($companyCodeF == null ? 43 : $companyCodeF.hashCode());
        String $midmancode = this.getMidmancode();
        result = result * 59 + ($midmancode == null ? 43 : $midmancode.hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $citycodelevy = this.getCitycodelevy();
        result = result * 59 + ($citycodelevy == null ? 43 : $citycodelevy.hashCode());
        List $customerVasetehDto = this.getCustomerVasetehDto();
        result = result * 59 + ($customerVasetehDto == null ? 43 : ((Object)$customerVasetehDto).hashCode());
        return result;
    }

    public String toString() {
        return "CustomerDto(id=" + this.getId() + ", code=" + this.getCode() + ", name=" + this.getName() + ", nationalid=" + this.getNationalid() + ", economicid=" + this.getEconomicid() + ", bedsarfasl=" + this.getBedsarfasl() + ", bessarfasl=" + this.getBessarfasl() + ", ispurchaser=" + this.getIspurchaser() + ", isseller=" + this.getIsseller() + ", isamer=" + this.getIsamer() + ", sellerwithtax=" + this.getSellerwithtax() + ", isblacklist=" + this.getIsblacklist() + ", mandeh=" + this.getMandeh() + ", credit=" + this.getCredit() + ", custtype=" + this.getCusttype() + ", isvaseteh=" + this.getIsvaseteh() + ", vasetehporsant=" + this.getVasetehporsant() + ", commission=" + this.getCommission() + ", tel=" + this.getTel() + ", mobile=" + this.getMobile() + ", fax=" + this.getFax() + ", city=" + this.getCity() + ", citycode=" + this.getCitycode() + ", ostan=" + this.getOstan() + ", ostancode=" + this.getOstancode() + ", mantagheh=" + this.getMantagheh() + ", zipcode=" + this.getZipcode() + ", address=" + this.getAddress() + ", addresstitle=" + this.getAddresstitle() + ", moreAddress=" + this.getMoreAddress() + ", job=" + this.getJob() + ", birthdate=" + this.getBirthdate() + ", email=" + this.getEmail() + ", erpcode=" + this.getErpcode() + ", cCode=" + this.getCCode() + ", inputid=" + this.getInputid() + ", c_code=" + this.getC_code() + ", type=" + this.getType() + ", isupdate=" + this.getIsupdate() + ", isactive=" + this.isIsactive() + ", lastbuyprice=" + this.getLastbuyprice() + ", lastsellprice=" + this.getLastsellprice() + ", nationalCodeF=" + this.getNationalCodeF() + ", personalCodeF=" + this.getPersonalCodeF() + ", companyCodeF=" + this.getCompanyCodeF() + ", vasetehcount=" + this.getVasetehcount() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", midmancode=" + this.getMidmancode() + ", category=" + this.getCategory() + ", nickname=" + this.getNickname() + ", citycodelevy=" + this.getCitycodelevy() + ", selecttype=" + this.getSelecttype() + ", customerVasetehDto=" + this.getCustomerVasetehDto() + ")";
    }
}

